;This is a program to be used with Chapter 18 Putting It All Together.  
;This program is used to create a basic electronic keyer using many of 
;the programming techniques used throughout the PIC-MCU Programming for 
;Beginners text.


	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define TMR0_scale	.133			;TMR0 preload factor, this value gives 1000Hz toggle
#define	key			0x02			;RC2 transmitter key jack
#define	PTT			0x03			;RC3 transmitter PTT
;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count1			;used in first 1 mS delay
	count2			;used in second 1 mS delay
	h_byte
	l_byte
	dash
	dit_count_low
	w_temp			;used to hold w and status reg during interrupt service
	status_temp
	;********************************
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	call interrupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF       ;retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC
	movlw	b'00000111'	;comparator disconnected, low power state
	movwf	CMCON		;/
	movlw	b'11000000'	;globals enabled, peripherals enabled,TMR0 disabled
	movwf	INTCON
	movlw	b'00010001'	;left justified, Vdd ref, RC0 has ADC, ADC Stop, ADC turned on
	movwf	ADCON0
	movlw	b'00110001'	;TMR1 prescale 1:8, internal clock, TMR1 ON
	movwf	T1CON
	BANKSEL	Bank1		;select bank1
	movlw	b'00000001'	;TMR0 set-up:  pull-ups enabled,X,internal clk,X,
						;pre-scale tmr0, pre-scale 1:2 
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00010000'	;Fosc/8 for ADC
	movwf	ADCON1
	movlw	b'00000011'	;RA0 and RA1 as input for paddle RA2 
	movwf	TRISA		;program PORTA
	movlw	b'00000011'	;weak pull-ups on RA0, RA1
	movwf	WPUA
	movlw	b'00000001'	;RC0 input for ADC
	movwf	TRISC		;program PORTC
	movlw	b'00010000'	;RC0 analog, all other digital
	movwf	ANSEL
	movlw	b'00000001'	;TMR1 interrupt enabled
	movwf	PIE1
	BANKSEL	Bank0		;back to bank0
	clrf	PORTC

;*****************************************************************************
;*****************************************************************************
;main program
get_key_loop
	movf	PORTA,f
	btfsc	STATUS,Z
	goto	iombic			;use goto's here to avoid overwhelming limited stack space
	btfss	PORTA,0
	goto	send_dits
	btfss	PORTA,1
	goto	send_dahs
	goto	get_key_loop

iombic
	call	send_dit
	call	send_space
	call	send_dash
	call	send_space
	goto	get_key_loop

send_dits
	
	call	send_dit
	call	send_space
	goto 	get_key_loop

send_dahs
	
	call	send_dash
	call	send_space
	goto	get_key_loop

send_dash
	bsf		PORTC, PTT		;turn on PTT
	bsf		PORTC,key		;close key
;
	clrf	TMR1H
	clrf	TMR1L
	bcf		PIR1,TMR1IF
	bsf		T1CON,TMR1ON
;
	call	get_adc
	clrf	h_byte
;******************************************************************************
;The dash is 3 times the dit time interval.
;This code will multiply the ADC value read for the dit time
;by three.  First the low byte is stored in the temporary variable
;dash so we can work with it without currupting the original low byte.
;Second, multiply the dit time by 2 by bit rotating dash 
;left first with the MSB going into the carry bit (STATUS,C).
;Then bit rotate the carry bit into the high byte LSB position.  This completes
;the multiply by 2.  Finally add in original low byte to dash.  The
;possiblilty of a carry is checked and if there is a carry from the addition, the 
;value of the high byte is incremented by one.  The result is multiply by 3:
;times 2 plus one more.
;*******************************************************************************
x3	
	movfw	l_byte				;store a copy of the low byte in temporary variable dash
	movwf	dash
	bcf		STATUS,C			;make sure the carry bit is clear
	rlf		dash,w				;multiplying by 2 with overrun in carry bit
	rlf		h_byte				;multiply by 2 with carry bit placed in LSB
	bcf		STATUS,C			;make sure the carry bit is clear
	addwf	l_byte,f			;add in the original low byte to make times 3
	btfsc	STATUS,C			;check if there was a carry, if not skip the increment of the high byte
	incf	h_byte

	bcf		INTCON,T0IF			;make sure the tone generating interrupt is ready, clear interrupt flag
	bsf		INTCON,T0IE			;enable tone generating interrupt

outer_loop						;delay loop one dash length by counting 1mSec delays

;delay1mS						;delay subrouting place here to avoid overwhelming the limit 
								;stack space of the PIC
        movlw   .198			
        movwf   count2
        nop
        goto    $+1
        goto    $+1
dly1mS2       
        goto    $+1
        decfsz  count2, F
        goto    dly1mS2
  
	decfsz	l_byte,f
	goto	outer_loop
	movf	h_byte,f
	btfsc	STATUS,Z			;check if high byte of count is zero, if it is, exit sending dashes
	goto	exit_dash
	decf	h_byte,f			;if not decrease counter high byte by one and continue the countdown
	goto	outer_loop

exit_dash
	bcf		INTCON,T0IF	
	bcf		INTCON,T0IE
	return


send_dit
	bsf		PORTC,PTT			;turn on PTT
	bsf		PORTC,key			;close key
;
	clrf	TMR1H
	clrf	TMR1L
	bcf		PIR1,TMR1IF
	bsf		T1CON,TMR1ON
;
	bcf		INTCON,T0IF
	bsf		INTCON,T0IE
	goto	$+2					;skip over the bcf PORTC,key line
send_space
	bcf		PORTC,key			;open key
	call	get_adc
	clrf	h_byte
	movwf	dit_count_low
dit_loop

;delay1mS						;delay routine contained here instead of using
								;a called subroutine to avoid stack overflow issues
        movlw   .198
        movwf   count1
        nop
        goto    $+1
        goto    $+1
dly1mS1        
        goto    $+1
        decfsz  count1, f
        goto    dly1mS1

	decfsz	dit_count_low,f
	goto	dit_loop
	bcf		INTCON,T0IF
	bcf		INTCON,T0IE
	return

;*****************************************************************************

interrupt_service			;an interrupt automatically clears GIE to
							;disable interrupts

;The following saving w reg and STATUS during interrupts and returns w reg and STATUS
;registers back when returning from the interrupt.  This helps to prevent
;problems when there are mulipule calls to subroutines while there are
;interrupts going on.

	movwf	w_temp			;copy w reg into a temporary variable
	swapf	STATUS,w		;using swap here because it does not affect STATUS
	movwf	status_temp		;copy swapped STATUS into temporary variable
;**************************************************************************
	btfsc	PIR1,TMR1IF		;check if TMR1 caused interrupt
	goto	PTT_service		;if so, turn off PTT
	bcf		INTCON,T0IF		;clear TMR0 interrupt
	movlw	TMR0_scale		;reset TMR0 scaling
	movwf	TMR0
	movlw	b'00010000'		;set up to toggle RC4
	xorwf	PORTC,f
	bcf		INTCON,T0IF		;clear TMR0 interrupt
	goto	return_interrupt;to not affect TMR1 and the PTT line
PTT_service					;called when PPT time is expired
	btfsc	PORTC,key		;if key is still down reset PTT
	goto	reset_PTT
	bcf		PORTC,PTT		;turn off PTT
	bcf		T1CON,TMR1ON	;turn off TMR1
	bcf		PORTC,4			;make sure speaker I/O line is low to reduce current consumption

	movlw	b'01000000'		;allow peripheral interrupts from TMR1
	movwf	INTCON			
;
reset_PTT
	movlw	b'00000011'
	xorwf	PORTA,w
	btfss	STATUS,Z
	bsf		PORTC, PTT
	bcf		PIR1,TMR1IF		;clear TMR1 interrupt flag

return_interrupt
;*****************************************************************************
	swapf	status_temp,w	;returning w reg and STATUS to pre-interrupt conditions
	movwf	STATUS			;using swapf and movwf because it does not affect STATUS
	swapf	w_temp,f
	swapf	w_temp,w
;*****************************************************************************
	retfie					;sets GIE enabling global interrupts
;*****************************************************************************	



get_adc
	bsf		ADCON0,GO	;set GO bit to begin ADC conversion
wait_ADC
	btfsc	ADCON0,NOT_DONE	;check if ADC complete (cleared bit)
	goto	wait_ADC		;if not, loop and wait until clear

	movlw	.252			;low side limit for resistor value
	subwf	ADRESH,w
	btfss	STATUS, C
	goto	check_low_limit
	movlw	.252
	movwf	l_byte
	return
check_low_limit
	movlw	.24				;high side limit for resistor value
	subwf	ADRESH,w
	btfss	STATUS,C
	goto	exit_ADC
	movfw	ADRESH
	movwf	l_byte
	return
	
exit_ADC
	movlw	.24	
	movwf	l_byte
	return
;*****************************************************************************


	end
